# Cloudflare Edge Setup (concise)

## SSL/TLS
- Mode: Full (Strict)
- HSTS: on (max-age 31536000, includeSubDomains, preload)

## Transform Rules (HTTP Request)
1) Lowercase host
   - Expression: `(http.host ne to_lower(http.host))`
   - Action: "Lowercase host"

2) Normalize trailing slash
   - Expression: `(ends_with(http.request.uri.path, "/") and http.request.uri.path ne "/")`
   - Action: Remove trailing slash

3) Force https header for origin hints
   - Expression: `true`
   - Action: Set header `X-Forwarded-Proto: https`

## WAF Custom Rules
- Block obvious SQLi/XSS:
  - `(http.request.uri.query contains "' or 1=1" or http.request.uri.query contains "<script")`
  - Action: Block
- Challenge unknown UA to /r/*:
  - `(starts_with(http.request.uri.path, "/r/") and not http.user_agent contains "Mozilla")`
  - Action: Managed Challenge

## Rate Limiting Rules
- `/r/*` 120 req per 10s per IP; action: throttle/challenge.

## Cache
- Cache bypass by default; cache static only. Dynamic `/r/*` set to `Cache: Bypass` at edge; origin sends `Cache-Control: private,max-age=60` for browser caching only.

## Load Balancer (optional)
- Pool A/B origins; health check `/healthz` 200.
