<?php
declare(strict_types=1);

use App\Http\Controller\RedirectController;
use App\Http\Middleware\RateLimiterMiddleware;
use Slim\App;
use Psr\Http\Message\ResponseInterface;
use Psr\Http\Message\ServerRequestInterface;

return function (App $app): void {
    $app->get('/healthz', function (ServerRequestInterface $request, ResponseInterface $response): ResponseInterface {
        $response->getBody()->write('ok');
        return $response->withStatus(200);
    });

    $app->get('/r/{code}', RedirectController::class)
        ->add(RateLimiterMiddleware::class);
};
