<?php
declare(strict_types=1);

use DI\ContainerBuilder;
use Dotenv\Dotenv;
use Nyholm\Psr7\Factory\Psr17Factory;
use Slim\App;
use Slim\Factory\AppFactory;

require __DIR__ . '/../vendor/autoload.php';

$dotenv = Dotenv::createImmutable(dirname(__DIR__));
$dotenv->safeLoad();

$containerBuilder = new ContainerBuilder();
$containerBuilder->addDefinitions(require __DIR__ . '/../config/container.php');
$container = $containerBuilder->build();

AppFactory::setContainer($container);
/** @var App $app */
$app = AppFactory::create(new Psr17Factory());

// Routing and error middleware
$app->addRoutingMiddleware();
$displayErrorDetails = ($_ENV['APP_ENV'] ?? 'prod') === 'dev';
$errorMiddleware = $app->addErrorMiddleware($displayErrorDetails, false, false);

(require __DIR__ . '/../config/routes.php')($app);

$app->run();
