<?php
declare(strict_types=1);

namespace App\Http\Middleware;

use Predis\Client as Redis;
use Psr\Http\Server\MiddlewareInterface;
use Psr\Http\Server\RequestHandlerInterface;
use Psr\Http\Message\ServerRequestInterface;
use Psr\Http\Message\ResponseInterface;
use Nyholm\Psr7\Response;

final class RateLimiterMiddleware implements MiddlewareInterface
{
    public function __construct(private Redis $redis)
    {
    }

    public function process(ServerRequestInterface $request, RequestHandlerInterface $handler): ResponseInterface
    {
        $ip = $request->getServerParams()['REMOTE_ADDR'] ?? '0.0.0.0';
        $key = 'ratelimit:' . $ip;
        $limit = 120;
        $ttl = 10;

        $count = (int) $this->redis->incr($key);
        if ($count === 1) {
            $this->redis->expire($key, $ttl);
        }

        if ($count > $limit) {
            return (new Response(429))
                ->withHeader('Retry-After', (string) $ttl);
        }

        return $handler->handle($request);
    }
}
