<?php

use App\Domain\Rule\RuleEngine;

it('decides fallback when VPN is detected', function () {
    $engine = new RuleEngine(fn() => true); // force VPN true
    $decision = $engine->decide([
        'country_allow' => ['id'],
        'device' => 'any',
        'target_url' => 'https://allowed.example',
        'fallback_url' => 'https://fallback.example'
    ], '1.2.3.4', 'Mozilla/5.0', 'id', false, 'web');

    expect($decision->useFallback)->toBeTrue();
});

it('allows redirect when country matches and no vpn', function () {
    $engine = new RuleEngine(fn() => false);
    $decision = $engine->decide([
        'country_allow' => ['id', 'us'],
        'device' => 'any',
        'target_url' => 'https://allowed.example',
        'fallback_url' => 'https://fallback.example'
    ], '1.2.3.4', 'Mozilla/5.0', 'id', false, 'web');

    expect($decision->useFallback)->toBeFalse();
    expect($decision->url)->toBe('https://allowed.example');
});
