export default {
  async fetch(request, env, ctx) {
    const url = new URL(request.url);
    if (url.pathname.startsWith('/edge/links/')) {
      const code = url.pathname.split('/').pop();
      const key = `link:${code}`;
      let data = await env.LINKS.get(key, { type: 'json' });
      if (!data) {
        // Fetch from origin API
        const origin = env.ORIGIN_API || 'https://api.example.com';
        const r = await fetch(`${origin}/api/v1/links/${code}`);
        if (r.ok) {
          data = await r.json();
          await env.LINKS.put(key, JSON.stringify(data), { expirationTtl: 60 });
        } else {
          return new Response('not found', { status: 404 });
        }
      }
      return new Response(JSON.stringify(data), {
        headers: { 'content-type': 'application/json' }
      });
    }
    return fetch(request);
  }
}
